/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef _tResponseGen_h
#define _tResponseGen_h

#include "drmcommon.h"

#ifdef __cplusplus
extern "C" {
#endif

DRM_RESULT TestLicResponseSetClientID(CLIENTID *pClientID);

DRM_RESULT TestResponseInit(IN _XMBContext *pbContext, IN DRM_DWORD cbContext);
DRM_RESULT TestResponseAddLicense(IN _XMBContext *pbContext, IN DRM_CONST_STRING *pwszLicense);
DRM_RESULT TestResponseAddNode(IN _XMBContext *pbContext, 
							IN const DRM_CONST_STRING *pwszNodeName,
							IN const DRM_CONST_STRING *pwszAttrName,
							IN const DRM_CONST_STRING *pwszAttrValue,
							IN const DRM_BYTE *pbData,
							IN const DRM_DWORD cbData);
#if DRM_SUPPORT_REVOCATION
DRM_RESULT TestResponseAddRevocationInfo(IN _XMBContext *pbContext, IN DRM_CONST_STRING *pwszRevocationInfo);
DRM_RESULT TestResponseAddRevocation(IN _XMBContext *pbContext, IN DRM_CONST_STRING *pwszGUID, IN DRM_CONST_STRING *pwszRevocation);
#endif /* DRM_SUPPORT_REVOCATION */

/*	Caller should free **ppbResponse. */
DRM_RESULT TestResponseGetResponse(IN _XMBContext *pbContext, OUT DRM_BYTE **ppbResponse, OUT DRM_DWORD *pcbResponse);
 
#ifdef __cplusplus
}
#endif
#endif /*_tResponseGen_h*/
